/*
USE GrowthZone_Instance1_Production
USE GrowthZone_Instance1_ProductionClone

DECLARE @TenantId INT = 1903

SELECT CONCAT(t.TenantId, ' - ', REPLACE(REPLACE(t.Name,'|',' '), '', ''))
FROM Tenants t
WHERE t.TenantId = @TenantId

--Run this (include from Line 5) to verify you have a ContactId in Tenant. Important for import.
SELECT *
FROM Contacts c
WHERE c.LoginId = --Put Your LoginId here
AND c.TenantId = @TenantId
*/

--Use this to look at file. Make sure to change the table to newly imported one.
--SELECT * FROM MNDB013.GZ_BackupTablesArchive.dbo.T1903_GZ00150280_RPAC_Import_20220830 x

--clears temp table #TempScheduledBilling in the event you are rerunning after some data fixes
IF OBJECT_ID (N'tempdb.dbo.#TempScheduledBilling') IS NOT NULL
DROP TABLE #TempScheduledBilling
GO

--Create table variable @ImportItems. Staging area for import data.
DECLARE @ImportItems TABLE (
	ContactId INT, Contact NVARCHAR(MAX), MembershipTypeId INT, MembershipType NVARCHAR(MAX), RPACSaleableItemId INT, RPACSaleableItem NVARCHAR(MAX), RPACAmount DECIMAL(14,4),
	ExistingSaleableItemId INT,	ExistingSaleableItem NVARCHAR(MAX)
	)

--Get MembershipTypeIds and SaleableItemIds
INSERT INTO @ImportItems
SELECT x.ContactId, x.Contact_Name, mt.MembershipTypeId, mt.Name, si1.SaleableItemId, si1.Name, x.RPAC_Voluntary_Amount, si2.SaleableItemId, si2.Name
FROM MNDB013.GZ_BackupTablesArchive.dbo.T1903_GZ00150280_RPAC_Import_20220830 x --Import file
INNER JOIN SaleableItems si1--Get SaleableItemId for RPAC_Voluntary_Goods_Service
	ON x.RPAC_Voluntary_Goods_Service = si1.Name 
		AND si1.TenantId = 1903
		AND si1.IsDeleted = 0
		AND si1.IsActive = 1
INNER JOIN SaleableItems si2 --Get SaleableItemId for Goods_Service_to_Attache_To
	ON x.Goods_Service_to_Attache_To = si2.Name
		AND si2.TenantId = 1903
		AND si2.IsDeleted = 0
		AND si2.IsActive = 1
INNER JOIN MembershipTypes mt --Get MembershipTypeId for Membership_Type
	ON x.Membership_Type = mt.Name
		AND mt.TenantId = 1903
		AND mt.IsDeleted = 0
		AND mt.IsActive = 1

--You can uncomment the following and run with above if you want to see what is in here
--SELECT * FROM @ImportItems

--Create table variable @NewestMembershipActivations. Make sure we are using the newest MembershipActivations 
DECLARE @NewestMembershipActivations TABLE (
	MembershipId INT, MembershipActivationId INT, MembershipTypeId INT, MembershipType NVARCHAR(MAX), ContactId INT, TermId INT, TenantId INT, BillingContactId INT, PrintInvoice BIT, EmailInvoice BIT
	)

--Get newest MembershipActivations
;WITH MembershipActivations_CTE AS
(
	SELECT
		ROW_NUMBER() OVER (PARTITION BY m.MembershipId ORDER BY ma.MembershipActivationId DESC) rn,
		m.MembershipId, ma.MembershipActivationId, m.MembershipTypeId, mt.Name AS MembershipType, m.OwnerContactId, m.TermId, m.TenantId, m.BillingContactId, m.PrintInvoice, m.EmailInvoice
	FROM Memberships m
	INNER JOIN MembershipActivations ma
		ON m.MembershipId = ma.MembershipId
			AND m.TenantId = ma.TenantId
			AND ma.IsDeleted = 0
			AND ma.EndDate IS NULL
	INNER JOIN MembershipTypes mt
		ON m.MembershipTypeId = mt.MembershipTypeId
			AND m.TenantId = mt.TenantId
			AND mt.IsDeleted = 0
			AND mt.IsActive = 1
	WHERE m.IsDeleted = 0
	AND m.TenantId = 1903
	AND m.EndDate IS NULL
	AND m.MembershipStatusTypeId = 2
)
INSERT INTO @NewestMembershipActivations
SELECT mac.MembershipId, mac.MembershipActivationId, mac.MembershipTypeId, mac.MembershipType, mac.OwnerContactId, mac.TermId, mac.TenantId, mac.BillingContactId, mac.PrintInvoice, mac.EmailInvoice
FROM MembershipActivations_CTE mac
WHERE mac.rn = 1 --Only want the larget MembershipActivationId

--You can uncomment the following and run with above if you want to see what is in here
--SELECT * FROM @NewestMembershipActivations

--No match to active membership. Investigate and/or supply to customer for verification/manualy intervention.
SELECT *
FROM @ImportItems ii
LEFT OUTER JOIN @NewestMembershipActivations nma
	ON ii.ContactId = nma.ContactId
			AND ii.MembershipTypeId = nma.MembershipTypeId
WHERE nma.ContactId IS NULL --Can't find a match in Memberships.

--Match - RPAC already exists. Investigate and/or supply to customer for verification/manualy intervention.
SELECT *
FROM @ImportItems ii
INNER JOIN @NewestMembershipActivations nma
	ON ii.ContactId = nma.ContactId
			AND ii.MembershipTypeId = nma.MembershipTypeId
INNER JOIN ScheduledBilling sb --Look here for exising items.
	ON nma.TenantId = sb.TenantId
		AND nma.ContactId = sb.ContactId
		AND nma.MembershipId = sb.MembershipId
		AND nma.MembershipActivationId = sb.MembershipActivationId
		AND ii.RPACSaleableItemId = sb.SaleableItemId
		AND sb.IsDeleted = 0
		AND sb.EndDate IS NULL

--Match - Create - dump into #TempScheduledBilling
SELECT
	ii.RPACSaleableItemId AS SaleableItemId, nma.MembershipActivationId, nma.MembershipId, CONVERT(TINYINT, 0) AS BillFrequencyTypeId, CONVERT(DECIMAL(8,2), 1) AS Quantity, ii.RPACAmount AS Price,
	ii.ContactId, COALESCE(sb2.BillingContactId, nma.BillingContactId) AS BillingContactId, CONVERT(DATE, GETDATE()) AS StartDate, CONVERT(DATE, NULL) AS EndDate,
	CONVERT(SMALLINT, 1) AS MaximumCycles, CONVERT(DATE, NULL) AS LastBillDate, sb2.NextBillDate, CONVERT(SMALLINT, 1) AS RemainingCycles, CONVERT(INT, NULL) AS PaymentProfileId,
	CONVERT(BIT, 0) AS HideOnInvoice, COALESCE(sb2.TermId, nma.TermId) AS TermId, COALESCE(sb2.PrintInvoice, nma.PrintInvoice) AS PrintInvoice, COALESCE(sb2.EmailInvoice, nma.EmailInvoice) AS EmailInvoice,
	ii.RPACSaleableItem AS Description, sb2.BillingAddressId, sb2.BillingEmailId, CONVERT(BIT, 0) AS IsDeleted, ii.RPACAmount AS AnnualizedAmount, CONVERT(TINYINT, 0) AS AmountFrequencyDisplayTypeId,
	ii.RPACAmount AS AmountRemaining, ii.RPACAmount AS TermPrice, COALESCE(sb2.DurationMonths, 12) AS DurationMonths
INTO #TempScheduledBilling
FROM @ImportItems ii
INNER JOIN @NewestMembershipActivations nma
	ON ii.ContactId = nma.ContactId
			AND ii.MembershipTypeId = nma.MembershipTypeId
LEFT OUTER JOIN ScheduledBilling sb --check if RPAC exists
	ON nma.TenantId = sb.TenantId
		AND nma.ContactId = sb.ContactId
		AND nma.MembershipId = sb.MembershipId
		AND nma.MembershipActivationId = sb.MembershipActivationId
		AND ii.RPACSaleableItemId = sb.SaleableItemId
		AND sb.IsDeleted = 0
		AND sb.EndDate IS NULL
LEFT OUTER JOIN ScheduledBilling sb2 --Get data from existing ScheduledBilling items
	ON nma.TenantId = sb2.TenantId
		AND nma.ContactId = sb2.ContactId
		AND nma.MembershipId = sb2.MembershipId
		AND nma.MembershipActivationId = sb2.MembershipActivationId
		AND ii.ExistingSaleableItemId = sb2.SaleableItemId
		AND sb2.IsDeleted = 0
		AND sb2.EndDate IS NULL
WHERE sb.ScheduledBillingId IS NULL --Only if the Billing item doesn't exist.

--Check #TempScheduledBilling
SELECT * FROM #TempScheduledBilling tsb

--Insert #TempScheduledBilling
BEGIN TRAN
DECLARE
	@TenantId INT = 1903,
	@TableName NVARCHAR(MAX) = 'ScheduledBilling',
	@TempTableName NVARCHAR(MAX) = '#TempScheduledBilling'
DECLARE @UserId INT = (
SELECT MIN(c.ContactId)
FROM Contacts c
WHERE c.LoginId = --Put Your LoginId here
AND c.TenantId = @TenantId)

EXEC GenerateAuditInfoAndInsertData @TableName,@TempTableName,@TenantId,@UserId
ROLLBACK TRAN
COMMIT TRAN


/* temp table cleanup
IF OBJECT_ID (N'tempdb.dbo.#TempScheduledBilling') IS NOT NULL
DROP TABLE #TempScheduledBilling
GO
*/